'use strict';

const base = require('../base.js');
const { assert } = require('chai');

describe('server additional information API', () => {
  it('server version', async function () {
    if (process.env.srv === 'skysql' || process.env.srv === 'skysql-ha' || process.env.srv === 'maxscale') this.skip();

    const res = await shareConn.query('SELECT VERSION() a');
    assert.deepEqual(res, [{ a: shareConn.serverVersion() }]);
  });

  it('server type', function () {
    if (!process.env.srv) this.skip();
    assert.equal(process.env.srv !== 'mysql', shareConn.info.isMariaDB());
  });
});
